# coding: utf-8
from tkinter import *
from tkinter.filedialog import askopenfilename
import gettext
import os


class Interface(Frame):
    def __init__(self, fenetre, **kwargs):
        Frame.__init__(self, fenetre, **kwargs)
        self.pack(fill=BOTH)
        self.ok_convert = False
        self.filename = ""
        self.gFilename = ""
        self.gFileNameStr = StringVar()
        self.gFileNameStr.set(_("Aucun fichier ouvert"))
        self.pen_up_code = StringVar()
        self.pen_down_code = StringVar()
        self.pen_up_code.set(_("Tapez votre GCODE"))
        self.pen_down_code.set(_("Tapez votre GCODE"))

        # Création de nos widgets
        self.gcodeFileFrame = LabelFrame(self, text=_("Votre fichier GCODE"), height=60, padx=5, pady=5)
        self.gcodeFileFrame.pack(fill=X)
        self.button_open_GCODE = Button(self.gcodeFileFrame, text=_("Ouvrir"), command=self.openfile)
        self.button_open_GCODE.pack(side=LEFT, padx=5, pady=5)
        self.gcodeFileName = Label(self.gcodeFileFrame, textvariable=self.gFileNameStr)
        self.gcodeFileName.pack(side=RIGHT, padx=5, pady=5)

        self.pen_frame = Frame(self, height=60)
        self.pen_frame.pack(fill=X)

        self.pen_up_Frame = LabelFrame(self.pen_frame, text=_("GCODE pour lever le crayon"), padx=5, pady=5)
        self.pen_up_Frame.pack(side=LEFT)
        self.entry_pen_up = Entry(self.pen_up_Frame, textvariable=self.pen_up_code, width=20)
        self.entry_pen_up.pack(fill=X)

        self.pen_down_frame = LabelFrame(self.pen_frame, text=_("GCODE pour baisser le crayon"), padx=5, pady=5)
        self.pen_down_frame.pack(side=RIGHT)
        self.entry_pen_down = Entry(self.pen_down_frame, textvariable=self.pen_down_code, width=20)
        self.entry_pen_down.pack(fill=X)

        self.convert_button = Button(self, text=_("CONVERTIR"), height=60, bg='RED', command=self.convert_gcode)
        self.convert_button.pack(fill=X)

    def openfile(self):
        import os
        self.filename = askopenfilename(title=_("Ouvrir votre fichier GCODE"),
                                        filetypes=[(_("Fichier GCode"), '*.gcode *.g'), (_("Tous les fichiers"), '.*')])
        if isinstance(self.filename, tuple):
            self.gFileNameStr.set(_("Aucun fichier ouvert"))
            self.ok_convert = False
            self.convert_button['bg'] = 'red'

        elif not self.filename:
            self.gFileNameStr.set(_("Aucun fichier ouvert"))
            self.ok_convert = False
            self.convert_button['bg'] = 'red'
        else:
            self.gFilename = os.path.basename(self.filename)
            self.gFileNameStr.set(self.gFilename)
            self.ok_convert = True
            self.convert_button['bg'] = 'green'

    def convert_gcode(self):
        import os
        count_GO = 0
        count_G1 = 0

        if self.ok_convert:
            gFileS = open(self.filename, "r")
            gFileD = open(os.path.splitext(self.filename)[0] + "_p.gcode", "w")
            gLine = gFileS.readline()

            while gLine:
                if "G0" in gLine and count_GO == 0:
                    gFileD.write(self.entry_pen_up.get() + "\n")
                    gFileD.write(gLine)
                    count_G1 = 0
                    count_GO += 1
                elif "G1" in gLine and count_G1 == 0:
                    gFileD.write(self.entry_pen_down.get() + "\n")
                    gFileD.write(gLine)
                    count_GO = 0
                    count_G1 += 1
                else:
                    gFileD.write(gLine)

                gLine = gFileS.readline()

            gFileS.close()
            gFileD.close()
            self.quit()


en = gettext.translation('plotter', localedir='locale', languages=['en'])
language = os.getenv('LANG')
if "fr" in language:
    _ = lambda s: s
else:
    en.install()

fenetre = Tk()
fenetre.minsize(width=500, height=180)
fenetre.maxsize(width=500, height=180)
fenetre.resizable(width=FALSE, height=False)
fenetre.title(_("Convertisseur de fichier GCODE pour Table Traçante"))
interface = Interface(fenetre)
interface.mainloop()
